class US_RelicMutator extends Mutator config(UniversalSoldiers);

var config bool	bSpeedRelic,
		bDamageRelic,
		bDefenseRelic,
		bLethalAuraRelic,
		bHealthRegenRelic,
		bRadarRelic;

var bool Initialized;
var int NumPoints;

function PostBeginPlay()
{
local NavigationPoint NP;

	Super.PostBeginPlay();

	if (Initialized)
		{
		return;
		}
	Initialized = True;

	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if (NP.IsA('PathNode'))
			{
			NumPoints++;
			}
		}

	SetTimer(0.9,True);
}

function Timer()
{
local Pawn P;
local int PointCount, NavPoint;
local NavigationPoint NP;
local Inventory Inv;
local bool bSpeed,bDamage,bDefense,bAura,bHealth,bRadar;

	ForEach AllActors(class'Inventory', Inv)
		{
		if ( Inv.IsA('Relic_Speed') )
			bSpeed = True;
		else if ( Inv.IsA('Relic_Damage') )
			bDamage = True;
		else if ( Inv.IsA('Relic_Defense') )
			bDefense = True;
		else if ( Inv.IsA('Relic_Aura') )
			bAura = True;
		else if ( Inv.IsA('Relic_HealthRegen') )
			bHealth = True;
		else if ( Inv.IsA('Relic_Radar') )
			bRadar = True;
		}
	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			if ( US_PRI(P.PlayerReplicationInfo).bHasSpeed )
				bSpeed = True;
			if ( US_PRI(P.PlayerReplicationInfo).bHasDamage )
				bDamage = True;
			if ( US_PRI(P.PlayerReplicationInfo).bHasDefense )
				bDefense = True;
			if ( US_PRI(P.PlayerReplicationInfo).bHasAura )
				bAura = True;
			if ( US_PRI(P.PlayerReplicationInfo).bHasHealthRegenRelic )
				bHealth = True;
			if ( US_PRI(P.PlayerReplicationInfo).bHasRadar )
				bRadar = True;
			}
		}


	if ( !bSpeed && bSpeedRelic )
		{
		NavPoint = Rand(NumPoints);
		for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
			{
			if ( NP.IsA('PathNode') )
				{
				if (PointCount == NavPoint)
					{
					AddSpeed(NP);
					}
				PointCount++;
				}
			}
		}
	if ( !bDamage && bDamageRelic )
		{
		NavPoint = Rand(NumPoints);
		for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
			{
			if ( NP.IsA('PathNode') )
				{
				if (PointCount == NavPoint)
					{
					AddDamage(NP);
					}
				PointCount++;
				}
			}
		}
	if ( !bDefense && bDefenseRelic)
		{
		NavPoint = Rand(NumPoints);
		for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
			{
			if ( NP.IsA('PathNode') )
				{
				if (PointCount == NavPoint)
					{
					AddDefense(NP);
					}
				PointCount++;
				}
			}
		}
	if ( !bAura && bLethalAuraRelic)
		{
		NavPoint = Rand(NumPoints);
		for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
			{
			if ( NP.IsA('PathNode') )
				{
				if (PointCount == NavPoint)
					{
					AddAura(NP);
					}
				PointCount++;
				}
			}
		}
	if ( !bHealth && bHealthRegenRelic)
		{
		NavPoint = Rand(NumPoints);
		for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
			{
			if ( NP.IsA('PathNode') )
				{
				if (PointCount == NavPoint)
					{
					AddHealthRegen(NP);
					}
				PointCount++;
				}
			}
		}
	if ( !bRadar && bRadarRelic)
		{
		NavPoint = Rand(NumPoints);
		for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
			{
			if ( NP.IsA('PathNode') )
				{
				if (PointCount == NavPoint)
					{
					AddRadar(NP);
					}
				PointCount++;
				}
			}
		}
	//Added:
	Super.Timer();
}

function AddSpeed(NavigationPoint PN)
{
local Inventory Inv;

	Inv = Spawn(Class'Relic_Speed',,,PN.Location);
}

function AddDamage(NavigationPoint PN)
{
local Inventory Inv;

	Inv = Spawn(Class'Relic_Damage',,,PN.Location);
}

function AddDefense(NavigationPoint PN)
{
local Inventory Inv;

	Inv = Spawn(Class'Relic_Defense',,,PN.Location);
}

function AddAura(NavigationPoint PN)
{
local Inventory Inv;

	Inv = Spawn(Class'Relic_Aura',,,PN.Location);
}

function AddHealthRegen(NavigationPoint PN)
{
local Inventory Inv;

	Inv = Spawn(Class'Relic_HealthRegen',,,PN.Location);
}

function AddRadar(NavigationPoint PN)
{
local Inventory Inv;

	Inv = Spawn(Class'Relic_Radar',,,PN.Location);
}

defaultproperties
{
bSpeedRelic=True
bDamageRelic=True
bDefenseRelic=True
bLethalAuraRelic=True
bHealthRegenRelic=True
bRadarRelic=True
bHidden=True
}
